#!/bin/bash

DEVICE="eth0"

if [ ! -z "$2" ]; then
    DEVICE="$2"
fi

if [ "$1"  == "--disable" ]; then
    tc qdisc delete dev "$DEVICE" root || echo "Unable to remove rules, did you specify the right device? Or were rules already removed?"
    logger IMHADMIN "Disabled bandwidtch shaping on $DEVICE"
    exit;
fi


if [ "$1" == "--enable" ]; then

########################################Begin Shaping Code
#Delete any qdiscs in place (reverts to standard pfifo)
#        tc qdisc delete dev $DEVICE root

#Set Device and default 'marking' (language not correct)
        tc qdisc add dev "$DEVICE" root handle 1: htb default 90 || echo "Unable to use tc to do bandwidth shaping - did you specify the wrong device? Is it already enabled?"

#Set 'Base' limits that will apply to all derivative clases
        tc class add dev "$DEVICE" parent 1: classid 1: htb rate 90mbit ceil 100mbit  || echo "Unable to use tc to do bandwidth shaping - did you specify the wrong device? Is it already enabled?"

#Set limits for default ":90"
        tc class add dev "$DEVICE" parent 1:1 classid 1:90 htb rate 85mbit ceil 88mbit || echo "Unable to use tc to do bandwidth shaping - did you specify the wrong device? Is is already enabled?"

        logger IMHADMIN "Enabled 100mbit bandwidtch shaping on $DEVICE"
    exit
fi


if [ "$1" == "--show" ]; then
#show all rules
        tc -s -d qdisc show dev "$DEVICE"
        tc -s -d class show dev "$DEVICE"
        tc -s -d filter show dev "$DEVICE" || echo "Couldn't list bandwish shaping properties - You used $DEVICE, is that right?"
        exit;
fi

if [ "$1" == "--status" ]; then
        if tc -s -d qdisc show dev "$DEVICE" | grep -q pfifo; then
            echo "Bandwidth shaping NOT enabled on $DEVICE";
            exit 0;
        else
            echo "Bandwidth shaping enabled on $DEVICE"
            exit 1;
        fi
fi

echo "This script enables/disabled traffic shaping
    Usage:
        $0 --enable - Enables bandwidth shaping on eth0
        $0 --disable - Disables bandwidth shaping on eth0
        $0 --status - Returns 1 if no shaping is enabled, 0 if enabled. (this
            is primarily for shell scripting/a nagios check if we need it)
        $0 --show - Displays the bandwidth shaping properties.
            If no shaping is in place a default setup will have default qdisc
            of pfifo and will will look similar to the following:
              qdisc pfifo_fast 0: bands 3 priomap  1 2 2 2 1 2 0 0 1 1 1 1 1 1 1 1
              Sent 383480 bytes 3266 pkt (dropped 0, overlimits 0 requeues 0)
              rate 0bit 0pps backlog 0b 0p requeues 0

            If bandwidth shaping is enabled, it will have the htb qdisk in place:
                qdisc htb 1: r2q 10 default 90 direct_packets_stat 0 ver 3.17
                 Sent 6022 bytes 67 pkt (dropped 0, overlimits 0 requeues 0)
                 rate 0bit 0pps backlog 0b 0p requeues 0
                class htb 1: root prio 0 quantum 200000 rate 90000Kbit ceil 100000Kbit
                    burst 12847b/8 mpu 0b overhead 0b cburst 14100b/8 mpu 0b overhead 0b level 0
                 Sent 0 bytes 0 pkt (dropped 0, overlimits 0 requeues 0)
                 rate 0bit 0pps backlog 0b 0p requeues 0
                 lended: 0 borrowed: 0 giants: 0
                 tokens: 1142 ctokens: 1128

                class htb 1:90 root prio 0 quantum 200000 rate 85000Kbit ceil 88000Kbit
                burst 12218b/8 mpu 0b overhead 0b cburst 12595b/8 mpu 0b overhead 0b level 0
                 Sent 6410 bytes 69 pkt (dropped 0, overlimits 0 requeues 0)
                 rate 0bit 0pps backlog 0b 0p requeues 0
                 lended: 69 borrowed: 0 giants: 0
                 tokens: 1131 ctokens: 1127

    If you need to specify an alternate device (a few servers do not have their primary adapter as eth0),
    you can do the following:
        $0 --enable eth1
        $0 --disable eth1
        "

exit
