#!/bin/bash
#---------------------------------------------------
#set_modsec
#---------------------------------------------------
# writen by JeffR July 21 2011
# revised w/error checking @ 8/4/11 by Erik S.
# disables or enables mod_security for all domains or a specific domain for a given user

echo

# load functions + banners
if [ -f /opt/sharedrads/radsfunctions.sh ]; then
    # shellcheck disable=SC1091
    source /opt/sharedrads/radsfunctions.sh
else
    # shellcheck disable=SC1091
    source /opt/dedrads/radsfunctions.sh
fi

if [ "$RADSCOLORS" == "off" ]; then
    radsbanner-nocolor
else
    radsbanner
fi

echo

####################
# help function -e #
####################
function help() {
    echo "This tool will enable or disable mod_security for an entire account or domain"
    echo
    echo "Usage:";
    echo "       set_modsec [username] [option] [target]";
    echo
    echo "Options:"
    echo "    --enable:  enable mod_security for specified domain(s)"
    echo "    --disable: disable mod_security for specified domain(s)"
    echo
    echo "Target:"
    echo "     domain: specify a single domain name to change mod_security for"
    echo "        all: change mod_security rules for ALL domains on an account"
    echo
    exit 1;
}


######################
# error checking -e  #
######################

if [ -z "$1" ]; then
    # no username supplied
    help
fi

if [ $# -lt 3 ];then
    # not all arguments received
    help
fi

if [ -f "/var/cpanel/users/${1}" ]; then
    # we have a good user
    MODUSER=$1   #username of acct
else
    # we don't have this user
    echo "ERROR: could not find userdata for $1 on this server."
    exit 0
fi

##################
# Declare Values #
##################

SET=$2    # enable or disable
DOMAIN=$3 # specific or all
if [ -f /etc/cpanel/ea4/is_ea4 ] ; then
    BASE_CONF_DIRS="/etc/apache2/conf.d/userdata/std/2_4/${MODUSER} /etc/apache2/conf.d/userdata/std/2/${MODUSER} /etc/apache2/conf.d/userdata/ssl/2_4/${MODUSER} /etc/apache2/conf.d/userdata/ssl/2/${MODUSER}"
else
    BASE_CONF_DIRS="/usr/local/apache/conf/userdata/std/2/${MODUSER} /usr/local/apache/conf/userdata/ssl/2/${MODUSER}"
fi


####################
#     function     #
####################

function DISABLE_MODSEC_ALL_DOMAINS_FOR_USER()
{
    echo "Please wait while I disable mod security for all domains owned by $MODUSER..."
    for BASE_CONF_DIR in $BASE_CONF_DIRS; do
        # shellcheck disable=SC2013
        for i in $(grep ": ${MODUSER}$" /etc/userdomains | awk -F':' '{print $1}'); do
            mkdir -p "${BASE_CONF_DIR}/${i}"
            echo "Writing ${BASE_CONF_DIR}/${i}/modsec.conf"
            echo "SecRuleEngine Off" > "${BASE_CONF_DIR}/${i}/modsec.conf"
        done
    done
    /scripts/rebuildhttpdconf
    /usr/local/cpanel/scripts/restartsrv_httpd --graceful
    echo "Done!"
}

####################
#     function     #
####################

function DISABLE_MODSEC_SPECIFIC_DOMAIN_FOR_USER()
{
    echo "Please wait while I automatically disable mod security for $DOMAIN..."
    for BASE_CONF_DIR in $BASE_CONF_DIRS; do
        mkdir -p "${BASE_CONF_DIR}/${DOMAIN}"
        echo "Writing ${BASE_CONF_DIR}/${DOMAIN}/modsec.conf"
        echo "SecRuleEngine Off" > "${BASE_CONF_DIR}/${DOMAIN}/modsec.conf"
    done
    /scripts/rebuildhttpdconf
    /usr/local/cpanel/scripts/restartsrv_httpd --graceful
    echo "Done!"
}

####################
#     function     #
####################

function ENABLE_MODSEC_ALL_DOMAINS_FOR_USER()
{
    echo "Please wait while I enable mod security for all domains owned by $MODUSER..."
    for BASE_CONF_DIR in $BASE_CONF_DIRS; do
        if [ -d "$BASE_CONF_DIR" ]; then
            find "$BASE_CONF_DIR" -type f -name 'modsec.conf' -delete -printf 'Removing %p\n'
        fi
    done
    /scripts/rebuildhttpdconf
    /usr/local/cpanel/scripts/restartsrv_httpd --graceful
    echo "Done!"
}

####################
#     function     #
####################

function ENABLE_MODSEC_SPECIFIC_DOMAIN_FOR_USER()
{
    echo "Please wait while I automatically enable mod security for $DOMAIN..."
    for BASE_CONF_DIR in $BASE_CONF_DIRS; do
        if [ -d "${BASE_CONF_DIR}/${DOMAIN}" ]; then
            find "${BASE_CONF_DIR}/${DOMAIN}" -type f -name 'modsec.conf' -delete -printf 'Removing %p\n'
        fi
    done
    /scripts/rebuildhttpdconf
    /usr/local/cpanel/scripts/restartsrv_httpd --graceful
    echo "Done!"
}

####################################################
# Run one of the funtions based on input variables #
####################################################

if [ "$SET" == "--disable" ] && [ "$DOMAIN" == all ]; then
    DISABLE_MODSEC_ALL_DOMAINS_FOR_USER
fi

if [ "$SET" == "--disable" ] && [ "$DOMAIN" != all ]; then
    DISABLE_MODSEC_SPECIFIC_DOMAIN_FOR_USER
fi

if [ "$SET" == "--enable" ] && [ "$DOMAIN" == all ]; then
    ENABLE_MODSEC_ALL_DOMAINS_FOR_USER
fi

if [ "$SET" == "--enable" ] &&  [ "$DOMAIN" != all ]; then
    ENABLE_MODSEC_SPECIFIC_DOMAIN_FOR_USER
fi

echo
